//
//  $Id: WXKWindowController.h 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "FJNContainableWindowController.h"

extern NSString *WXKToolbarReceiveItemIdentifier;         // receive: (defined in this method)
extern NSString *WXKToolbarSendItemIdentifier;            // send: (defined in this method)
extern NSString *WXKToolbarFetchListItemIdentifier;       // fetchList: (defined in this class)
extern NSString *WXKToolbarAddressUtilityItemIdentifier;  // launchAddressUtility: (defined in WXKAppDelegate)
extern NSString *WXKToolbarBookmarkUtilityItemIdentifier; // launchBookmarkUtility: (defined in WXKAppDelegate)
extern NSString *WXKToolbarFileUtilityItemIdentifier;     // launchFileUtility: (defined in WXKAppDelegate)
extern NSString *WXKToolbarMailUtilityItemIdentifier;     // launchMailUtility: (defined in WXKAppDelegate)

@class WXKProgressWindowController;

@interface WXKWindowController : FJNContainableWindowController

#pragma mark Class methods
+ (NSString *)metadataDirectory;

#pragma mark Action methods
- (IBAction)insertContent:(id)sender;
- (IBAction)reindexContent:(id)sender;

- (IBAction)send:(id)sender;
- (IBAction)receive:(id)sender;
- (IBAction)fetchList:(id)sender;

#pragma mark NSErrorRecoveryAttempting informal protocol
- (void)attemptRecoveryFromError:(NSError *)error optionIndex:(unsigned int)recoveryOptionIndex delegate:(id)delegate didRecoverSelector:(SEL)didRecoverSelector contextInfo:(void *)contextInfo;

@end


#pragma mark -

// Methods defined below are invoked in send: and receive:, respectively.
// Subclasss should implement these methods.

@interface WXKWindowController (Communication)

- (BOOL)receiveWithPassword:(NSString *)password progressController:(WXKProgressWindowController *)progress error:(NSError **)errorPtr;
- (BOOL)sendWithPassword:(NSString *)password progressController:(WXKProgressWindowController *)progress error:(NSError **)error;
- (BOOL)fetchListWithPassword:(NSString *)password progressController:(WXKProgressWindowController *)progress error:(NSError **)error;

@end

#pragma mark -

#import "FJNContainerArrayController.h"

@interface FJNContainerArrayController (WXKExtensions)

- (NSArray *)initializedObjectsWithDictionaries:(NSArray *)dictionaries;

@end